/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.store;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import java.util.Map;

public abstract class MaterialQuotas {
    protected long lastTime;
    protected final StoreSchedule storeSchedule;

    protected MaterialQuotas(long time, StoreSchedule storeSchedule, long matHorizonBase, StoreSchedule.MatHorizonTreatment matHorizonTreatment) {
        this.lastTime = time;
        this.storeSchedule = storeSchedule;
        Preconditions.checkArgument(GeneralizedRequest.isDateValid(matHorizonBase) && matHorizonTreatment != null || !GeneralizedRequest.isDateValid(matHorizonBase) && matHorizonTreatment == null);
    }

    public void changeQuota(Material material, double delta) {
        if (delta > 0.0) {
            throw new IllegalArgumentException("Only negative store deltas are supported by changeQuota.");
        }
        this.changeQuota(this.getQuotas().get(material), delta);
    }

    protected abstract void changeQuota(MaterialQuota var1, double var2);

    public double getQuota(Material material) {
        MaterialQuota quota = this.getQuotas().get(material);
        if (quota == null) {
            throw new IllegalArgumentException("Uninitialized material requested " + material);
        }
        return quota.getQuota();
    }

    protected abstract Map<Material, ? extends MaterialQuota> getQuotas();

    public abstract void setTime(long var1);

    public abstract Long getMaterialAvailableTime(Material var1, double var2);

    public String toString() {
        return this.getQuotas().toString();
    }

    protected long getAbsoluteMatHorizon(Material mat, long matHorizonBase, StoreSchedule.MatHorizonTreatment matHorizonTreatment) {
        if (!GeneralizedRequest.isDateValid(matHorizonBase)) {
            return -9223372036854775708L;
        }
        long rawHorizon = mat.getMaterialHorizon();
        return switch (matHorizonTreatment) {
            case StoreSchedule.MatHorizonTreatment.MATERIAL_SPECIFIC -> {
                if (GeneralizedRequest.isDateValid(rawHorizon)) {
                    yield rawHorizon + matHorizonBase;
                }
                yield mat.getMaterialHorizon();
            }
            case StoreSchedule.MatHorizonTreatment.NO_HORIZONS -> -9223372036854775708L;
            case StoreSchedule.MatHorizonTreatment.NULL_ALL -> matHorizonBase;
            case StoreSchedule.MatHorizonTreatment.NULL_FINITE -> {
                if (GeneralizedRequest.isDateValid(rawHorizon)) {
                    yield matHorizonBase;
                }
                yield mat.getMaterialHorizon();
            }
            case StoreSchedule.MatHorizonTreatment.NULL_MATERIALS -> {
                if (!(mat instanceof Product)) {
                    yield matHorizonBase;
                }
                if (GeneralizedRequest.isDateValid(rawHorizon)) {
                    yield rawHorizon + matHorizonBase;
                }
                yield mat.getMaterialHorizon();
            }
            default -> throw new IllegalArgumentException("Unknown material horizon treatment parameter.");
        };
    }

    protected static interface MaterialQuota {
        public double getQuota();
    }
}

